//
//  SwipesViewController.m
//  Swipes
//
//  Created by Robert Górczyński on 11-07-25.
//

#import "SwipesViewController.h"

#define kMinimumGestureLength    25 
#define kMaximumVariance         5 


@implementation SwipesViewController
@synthesize label; 
@synthesize gestureStartPoint; 

- (void)eraseText { 
    label.text = @""; 
} 

- (void)didReceiveMemoryWarning {
	// Jeżeli widok nie posiada widoku nadrzędnego, wówczas zostanie usunięty z pamięci.
    [super didReceiveMemoryWarning];
	
	// Usunięcie z pamięci wszelkich buforowanych danych, obrazów i innych zasobów, które obecnie nie są używanee.
}

- (void)viewDidUnload {
	// Usunięcie wszystkich „przytrzymanych” podwidoków widoku głównego,
    // na przykład self.myOutlet = nil;
    self.label = nil; 
    [super viewDidUnload]; 
}


- (void)dealloc {
    [label release]; 
    [super dealloc];
}

#pragma mark - 
- (void)touchesBegan:(NSSet *)touches withEvent:(UIEvent *)event {
    UITouch *touch = [touches anyObject]; 
    gestureStartPoint = [touch locationInView:self.view]; 
} 

- (void)touchesMoved:(NSSet *)touches withEvent:(UIEvent *)event { 
	UITouch *touch = [touches anyObject]; 
    CGPoint currentPosition = [touch locationInView:self.view]; 
	
    CGFloat deltaX = fabsf(gestureStartPoint.x - currentPosition.x); 
    CGFloat deltaY = fabsf(gestureStartPoint.y - currentPosition.y); 
	
    if (deltaX >= kMinimumGestureLength && deltaY <= kMaximumVariance) { 
        label.text = @"Wykryto machnięcie poziome"; 
        [self performSelector:@selector(eraseText) 
				   withObject:nil afterDelay:2]; 
    } 
    else if (deltaY >= kMinimumGestureLength && 
			 deltaX <= kMaximumVariance){ 
        label.text = @"Wykryto machnięcie pionowe"; 
        [self performSelector:@selector(eraseText) withObject:nil 
				   afterDelay:2]; 
    } 
} 

@end
